# Vespucci 19.1 Highlights

2023-07-04

### New disambiguation menu

Since March 2009 (Android was just half a year old then) we've been using the Android "context menu" to provide a way of disambiguating between different close together and geometry
sharing elements. This has always had some annoying limitations, particularly in conjunction with accessibility settings (font size and magnification). We've now replaced the context menu with
a custom modal that displays icons as a concise way of indicating the object type and allows horizontal scrolling to make the complete object description visible if necessary.

### Path pattern support disabled for Android 8 and earlier

On Android 8 and earlier the low level graphics library used by Android may stop Vespucci from start up if the data styling uses "path patterns", see vespucci.io/tutorials/faq/#error-messages-and-other-issues for more information. To avoid this from happening starting with 19.0.3 support for the patterns has been disabled on devices running Android 8 or older.

To some what lessen the impact we've added an additional data style without path patterns that in the future will contain different styling for the affected elements.

Further to provide a facility to recover from this and similar issues we've added a "safe" mode that the app can be started in via an Android shortcut. Currently this only protects against rendering issues, however it will be expanded in the future to cover more cases (data corruption and similar).

### Name templates

We now support JOSM style name templates in the presets and the default presets have been extended with these for nearly all route items. On matching objects without a name tag these will be used to generate a label for display purposes in the disambiguation menu and for nodes and closed ways. This removes the need for fake names for routes and allows to generate a descriptive label automatically, for example from "from" and "to" tags.

Name templates are included in the translation files and can be localized. 

Note: JOSM does not implement a consistent grammar for name templates, for example it doesn't require that quotes are escaped when they are nested in some situations. 
Our implementation will differ from JOSM for such reasons, however any template that works for Vespucci should work with JOSM too. 

### Modal for entering longer text in tags

A small number of OSM tags can contain longer texts, for example _description_ and _inscription_ tags these are difficult to enter in the standard one line text field. To make this simpler
for longer pieces of texts we've added a dedicated modal for text entry.

The modal will be displayed if either

- the preset contains a length field set to a value equal or larger than the current setting of the _Long string limit_ in the advanced preferences, or
- the length of the current value of the field is equal or larger than than _Long string limit_.

The default value of _Long string limit_ is 255, the maximum length (in characters) of an OSM tag value.

### Support for following the system theme 

Vespucci has always had a "dark" mode, long before such a thing was even a concept with google. In June 2015 with version 0.9.6 we added a "light" mode, version 19.1 now adds a further setting _Follow system_ for devices running Android 10 and later.

### Bookmark layer

Bookmarks now have their own layer that can be enabled via the layers modal, this simply displays the bookmark bounding box and the name. Additionally book mark names can now be edited.

## Miscellaneous

- Add improve area order when rendering by sorting closed ways according to bounding box size
- Add support custom headers from imagery configuration
- Add improved property editor behaviour in split screen mode
- Add improved diagnostics for the tile downloader and testing facility in layer modal
- Add support for sharing an Mapillary image including its id

# Upgrading from previous versions

* As the saved state file has changed you should upload any pending changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
